<?php

namespace Modular\ConnectorDependencies\Illuminate\Console\Scheduling;

use Modular\ConnectorDependencies\Illuminate\Console\Command;
class ScheduleTestCommand extends Command
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $name = 'schedule:test';
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Run a scheduled command';
    /**
     * Execute the console command.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    public function handle(Schedule $schedule)
    {
        $commands = $schedule->events();
        $commandNames = [];
        foreach ($commands as $command) {
            $commandNames[] = $command->command ?? $command->getSummaryForDisplay();
        }
        $index = array_search($this->choice('Which command would you like to run?', $commandNames), $commandNames);
        $event = $commands[$index];
        $this->line('<info>[' . date('c') . '] Running scheduled command:</info> ' . $event->getSummaryForDisplay());
        $event->run($this->laravel);
    }
}
