<?php

namespace Modular\ConnectorDependencies\Illuminate\Routing\Console;

use Modular\ConnectorDependencies\Illuminate\Console\Concerns\CreatesMatchingTest;
use Modular\ConnectorDependencies\Illuminate\Console\GeneratorCommand;
class MiddlewareMakeCommand extends GeneratorCommand
{
    use CreatesMatchingTest;
    /**
     * The console command name.
     *
     * @var string
     */
    protected $name = 'make:middleware';
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create a new middleware class';
    /**
     * The type of class being generated.
     *
     * @var string
     */
    protected $type = 'Middleware';
    /**
     * Get the stub file for the generator.
     *
     * @return string
     */
    protected function getStub()
    {
        return $this->resolveStubPath('/stubs/middleware.stub');
    }
    /**
     * Resolve the fully-qualified path to the stub.
     *
     * @param  string  $stub
     * @return string
     */
    protected function resolveStubPath($stub)
    {
        return file_exists($customPath = $this->laravel->basePath(trim($stub, '/'))) ? $customPath : __DIR__ . $stub;
    }
    /**
     * Get the default namespace for the class.
     *
     * @param  string  $rootNamespace
     * @return string
     */
    protected function getDefaultNamespace($rootNamespace)
    {
        return $rootNamespace . '\Http\Middleware';
    }
}
