<?php

declare(strict_types=1);

namespace MailerPress\Actions\ActionScheduler;

\defined('ABSPATH') || exit;

use MailerPress\Core\Attributes\Action;
use MailerPress\Core\Attributes\Filter;

final class AsInit
{
    #[Action('init')]
    public function initCron(): void
    {
        if (\function_exists('as_has_scheduled_action') && !as_has_scheduled_action('mailerpress_process_queue_worker')) {
            as_schedule_recurring_action(
                time(),
                1 * MINUTE_IN_SECONDS,
                'mailerpress_process_queue_worker',
                [],
                'daemon/mailerpress/process_queue_worker'
            );
        }

        if (\function_exists('as_has_scheduled_action') && !as_has_scheduled_action('mailerpress_as_clean')) {
            as_schedule_recurring_action(
                time(),
                WEEK_IN_SECONDS,
                'mailerpress_as_clean',
                [],
                'mailerpress'
            );
        }

        $expected_interval = 1 * DAY_IN_SECONDS;
        $stored_interval = get_option('mailerpress_check_bounces_interval', null);

        if (\function_exists('as_has_scheduled_action') && \function_exists('as_unschedule_all_actions') && \function_exists('as_schedule_recurring_action')) {
            // Si l'intervalle a changé ou si l'action n'existe pas, on la recrée
            if ($stored_interval !== $expected_interval || !as_has_scheduled_action('mailerpress_check_bounces')) {
                if (as_has_scheduled_action('mailerpress_check_bounces')) {
                    as_unschedule_all_actions('mailerpress_check_bounces');
                }
                as_schedule_recurring_action(
                    time(),
                    $expected_interval,
                    'mailerpress_check_bounces',
                    [],
                    'mailerpress'
                );
                update_option('mailerpress_check_bounces_interval', $expected_interval);
            }
        }

        if (!get_option(
            'mailerpress_access_tokens_scheduled',
            false
        ) && !as_next_scheduled_action('mailerpress_generate_access_tokens')) {
            as_schedule_single_action(time(), 'mailerpress_generate_access_tokens');
            update_option('mailerpress_access_tokens_scheduled', true);
        }
    }

    #[Filter('action_scheduler_queue_runner_concurrent_batches')]
    public function mailerpress_increase_concurrent_batches($concurrent_batches)
    {
        return 1;
    }

    #[Filter('action_scheduler_queue_runner_batch_size')]
    public function mailerpress_increase_queue_batch_size($batch_size)
    {
        return 5;
    }

    #[Filter(['action_scheduler_timeout_period', 'action_scheduler_failure_period'])]
    public function mailerpress_increase_timeout($timeout)
    {
        return $timeout * 3;
    }

    #[Filter('action_scheduler_default_cleaner_statuses')]
    public function mailerpress_default_cleaner_statuses($statuses)
    {
        $statuses[] = 'failed';
        return $statuses;
    }

    #[Filter('action_scheduler_cleanup_batch_size')]
    public function mailerpress_cleanup_batch_size($batch_size)
    {
        return 100;
    }
}
