<?php

declare(strict_types=1);

namespace MailerPress\Actions\Campaigns;

\defined('ABSPATH') || exit;

use MailerPress\Core\Attributes\Action;
use MailerPress\Core\Enums\Tables;

class Campaigns
{
    #[Action('mailerpress_batch_event', priority: 10, acceptedArgs: 3)]
    public function updateCampaignStatus(string $status, string $campaign_id, string $batch_id): void
    {
        global $wpdb;

        $table_name = Tables::get(Tables::MAILERPRESS_CAMPAIGNS);

        $wpdb->update(
            $table_name,
            [
                'status' => $status,
                'batch_id' => $batch_id,
                'updated_at' => current_time('mysql'), // Set to the current timestamp
            ],
            ['campaign_id' => $campaign_id], // Where condition
            ['%s', '%s'], // Data format: string for status and timestamp
            ['%d']        // Where condition format: integer for campaign_id
        );

        // Déclencher le hook mailerpress_campaign_sent seulement quand le statut est 'sent'
        if ($status === 'sent') {
            // Récupérer les données de la campagne et du batch pour le webhook
            $campaign = $wpdb->get_row(
                $wpdb->prepare(
                    "SELECT * FROM {$table_name} WHERE campaign_id = %d",
                    (int) $campaign_id
                ),
                \ARRAY_A
            );

            $batchTable = Tables::get(Tables::MAILERPRESS_EMAIL_BATCHES);
            $batch = $wpdb->get_row(
                $wpdb->prepare(
                    "SELECT * FROM {$batchTable} WHERE id = %d",
                    (int) $batch_id
                ),
                \ARRAY_A
            );

            // Préparer les données pour le webhook
            $webhookData = [
                'campaign_id' => (int) $campaign_id,
                'campaign_name' => $campaign['name'] ?? '',
                'campaign_subject' => $campaign['subject'] ?? '',
                'total_emails' => isset($batch['total_emails']) ? (int) $batch['total_emails'] : 0,
                'sent_emails' => isset($batch['sent_emails']) ? (int) $batch['sent_emails'] : 0,
                'error_emails' => isset($batch['error_emails']) ? (int) $batch['error_emails'] : 0,
                'sent_at' => $batch['updated_at'] ?? current_time('mysql'),
            ];

            // Déclencher le hook
            do_action('mailerpress_campaign_sent', (int) $campaign_id, $webhookData);
        }
    }
}
