<?php

declare(strict_types=1);

namespace MailerPress\Services;

\defined('ABSPATH') || exit;

use DI\DependencyException;
use DI\NotFoundException;
use MailerPress\Core\CapabilitiesManager;
use MailerPress\Core\Kernel;

class Activation
{
    /**
     * @throws DependencyException
     * @throws NotFoundException
     */
    public function activate(): void
    {
        update_option('mailerpress_activated', 'yes');
        $this->addDefaultPage();
        \MailerPress\Core\CapabilitiesManager::addCapabilities();
    }

    /**
     * @throws DependencyException
     * @throws NotFoundException
     */
    private function addDefaultPage(): void
    {
        wp_insert_post([
            'post_type' => Kernel::getContainer()->get('cpt-page-slug'),
            'post_status' => 'publish',
            'post_title' => 'Mailerpress',
            'post_content' => '[mailerpress_pages]',
        ]);
    }
}
