<?php

use MailerPress\Core\Enums\Tables;
use MailerPress\Core\Migrations\SchemaBuilder;
use MailerPress\Core\Migrations\CustomTableManager;

return function (SchemaBuilder $schema) {
    $schema->create(Tables::MAILERPRESS_CAMPAIGNS, function (CustomTableManager $table) {
        // Modify the status ENUM column to include 'active' and 'inactive'
        $table->modifyColumn('status', "ENUM(
            'draft',
            'scheduled',
            'in_progress',
            'sent',
            'pending',
            'error',
            'trash',
            'active',
            'inactive'
        ) NOT NULL DEFAULT 'draft'");

        $table->enum('campaign_type', ['newsletter', 'automated', 'automation'])->default('newsletter')->after('subject');
        $table->bigInteger('automation_id')->unsigned()->nullable()->after('campaign_type');

        $table->addIndex('campaign_type');
        $table->addIndex('automation_id');

        $table->addForeignKey('automation_id', Tables::MAILERPRESS_AUTOMATIONS, 'automation_id', 'CASCADE', 'RESTRICT');


        $table->setVersion('0.3.0')->migrate();
    });

    $schema->create(Tables::MAILERPRESS_EMAIL_BATCHES, function (CustomTableManager $table) {
        // Modify the status ENUM column to include 'active' and 'inactive'
        $table->modifyColumn('status', "ENUM(
        'pending',
        'in_progress',
        'completed',
        'failed',
        'scheduled',
        'sent'
    ) NOT NULL DEFAULT 'pending'");

        $table->setVersion('0.3.0')->migrate();
    });

    $schema->table(Tables::MAILERPRESS_CONTACT, function (CustomTableManager $table) {
        $table->string('access_token', 64)->nullable()->after('email'); // allow NULLs initially
        // no unique() here yet
        $table->setVersion('0.3.0');
    });

    $schema->create(Tables::MAILERPRESS_LIST, function (CustomTableManager $table) {
        $table->text('description')->nullable()->after('name');
        $table->setVersion('0.3.0'); // Important: bump version
    });
};
