<?php

use MailerPress\Core\Enums\Tables;
use MailerPress\Core\Migrations\SchemaBuilder;
use MailerPress\Core\Migrations\CustomTableManager;

return function (SchemaBuilder $schema) {

    $schema->create(Tables::MAILERPRESS_AUTOMATIONS,
        function (CustomTableManager $table) {
            $table->id('automation_id');
            $table->string('name');
            $table->text('description')->nullable();
            $table->enum('status', ['active', 'inactive', 'draft'])->nullable()->default('draft');
            $table->string('trigger_type', 100)->nullable();
            $table->longText('trigger_data')->nullable();
            $table->column('created_at', 'DATETIME')->nullable()->default('CURRENT_TIMESTAMP');
            $table->column('updated_at',
                'DATETIME')->nullable()->default('CURRENT_TIMESTAMP')->extra('ON UPDATE CURRENT_TIMESTAMP');
            $table->setVersion('0.0.1');
        });

    $schema->create(Tables::MAILERPRESS_AUTOMATIONS_STEPS,
        function (CustomTableManager $table) {
            $table->id('step_id');
            $table->unsignedBigInteger('automation_id');
            $table->unsignedBigInteger('parent_step_id')->nullable();
            $table->integer('step_order')->nullable()->default(0);
            $table->enum('type', ['trigger', 'action', 'condition', 'delay']);
            $table->string('name');
            $table->json('settings');
            $table->column('created_at', 'DATETIME')->nullable()->default('CURRENT_TIMESTAMP');

            $table->addIndex('automation_id');
            $table->addForeignKey('automation_id', Tables::MAILERPRESS_AUTOMATIONS, 'automation_id', 'CASCADE');

            $table->setVersion('0.0.1');
        });

    $schema->create(Tables::MAILERPRESS_AUTOMATIONS_STEP_LINKS,
        function (CustomTableManager $table) {
            $table->id();
            $table->unsignedBigInteger('from_step_id');
            $table->unsignedBigInteger('to_step_id');
            $table->string('condition_label', 100)->nullable();

            // Indexes
            $table->addIndex('from_step_id');
            $table->addIndex('to_step_id');

            // Foreign keys (both referencing the same table)
            $table->addForeignKey('from_step_id', Tables::MAILERPRESS_AUTOMATIONS_STEPS, 'step_id', 'CASCADE');
            $table->addForeignKey('to_step_id', Tables::MAILERPRESS_AUTOMATIONS_STEPS, 'step_id', 'CASCADE');

            $table->setVersion('0.0.1');
        });

    $schema->create('mailerpress_automations_steps_links',
        function (\MailerPress\Core\Migrations\CustomTableManager $table) {
            // Primary Key
            $table->id('id');

            // Foreign key columns
            $table->unsignedBigInteger('from_step_id');
            $table->unsignedBigInteger('to_step_id');

            // Optional label column
            $table->string('condition_label', 100)->nullable();

            // Indexes
            $table->addIndex('from_step_id');
            $table->addIndex('to_step_id');

            // Foreign keys
            $table->addForeignKey(
                'from_step_id',
                'mailerpress_automations_steps',
                'step_id',
                'CASCADE',
            );

            $table->addForeignKey(
                'to_step_id',
                'mailerpress_automations_steps',
                'step_id',
                'CASCADE',
            );

            // Versioning
            $table->setVersion('0.0.1');
        });

    $schema->create(
        Tables::MAILERPRESS_AUTOMATIONS_CONTACT,
        function (CustomTableManager $table) {
            $table->id();

            $table->unsignedBigInteger('automation_id');
            $table->unsignedBigInteger('contact_id');
            $table->unsignedBigInteger('current_step_id')->nullable();

            $table->enum('status', ['running', 'paused', 'completed', 'error'])
                ->nullable()
                ->default('running');

            $table->column('started_at', 'DATETIME')->nullable()->default('CURRENT_TIMESTAMP');
            $table->column('updated_at',
                'DATETIME')->nullable()->default('CURRENT_TIMESTAMP');

            // Indexes
            $table->addIndex('automation_id');

            // Foreign Keys
            $table->addForeignKey('automation_id', Tables::MAILERPRESS_AUTOMATIONS, 'automation_id', 'CASCADE');

            $table->setVersion('0.0.1');
        });

    $schema->create(
        Tables::MAILERPRESS_AUTOMATIONS_QUEUE,
        function (CustomTableManager $table) {
            $table->integer('id')->unsigned()->autoIncrement();
            $table->setPrimaryKey('id');

            $table->bigInteger('automation_id')->unsigned();
            $table->bigInteger('contact_id')->unsigned();
            $table->bigInteger('step_id')->unsigned();

            $table->datetime('run_at');
            $table->enum('status', ['pending', 'processing', 'completed', 'failed'])->nullable()->default('pending');
            $table->datetime('created_at')->nullable()->default('CURRENT_TIMESTAMP');

            $table->addIndex('automation_id');

            $table->addForeignKey('automation_id', Tables::MAILERPRESS_AUTOMATIONS, 'automation_id', 'CASCADE',
                'RESTRICT');

            $table->setVersion('0.0.1');
        }
    );


    $schema->create(
        Tables::MAILERPRESS_AUTOMATIONS_LOGS,
        function (CustomTableManager $table) {
            // Primary Key
            $table->id();

            // Columns
            $table->unsignedBigInteger('automation_id');
            $table->unsignedBigInteger('contact_id');
            $table->unsignedBigInteger('step_id');

            $table->enum('status', ['success', 'skipped', 'failed']);

            $table->column('executed_at', 'DATETIME')->nullable()->default('CURRENT_TIMESTAMP');
            $table->text('message')->nullable();

            // Indexes
            $table->addIndex('automation_id');

            // Foreign Key
            $table->addForeignKey(
                'automation_id',
                Tables::MAILERPRESS_AUTOMATIONS,
                'automation_id',
                'CASCADE'
            );

            // Versioning
            $table->setVersion('0.0.1');
        }
    );

};
