<?php

namespace MailerPress\Core\Migrations;

\defined('ABSPATH') || exit;

class Manager
{
    protected string $migrationPath;
    protected SchemaBuilder $schema;

    public function __construct(string $migrationPath)
    {
        $this->migrationPath = $migrationPath;
        $this->schema = new SchemaBuilder();
    }

    public function run(): void
    {
        $files = glob($this->migrationPath . '/*.php');
        sort($files); // Sort for consistent order

        foreach ($files as $file) {
            $migration = require $file;
            if (is_callable($migration)) {
                $migration($this->schema);
            }
        }

        $this->schema->migrate();
    }

    public function dryRun(): void
    {
        $files = glob($this->migrationPath . '/*.php');
        sort($files);

        foreach ($files as $file) {
            $migration = require $file;
            if (is_callable($migration)) {
                $migration($this->schema);
            }
        }

        $this->schema->dryRun();
    }

}
