<?php

declare(strict_types=1);

namespace MailerPress\Core\Enums;

\defined('ABSPATH') || exit;

class Tables
{
    public const MAILERPRESS_EMAIL_TRACKING = 'mailerpress_email_tracking';
    public const MAILERPRESS_CAMPAIGNS = 'mailerpress_campaigns';
    public const MAILERPRESS_CAMPAIGN_REVISIONS = 'mailerpress_campaigns_revisions';

    public const MAILERPRESS_CONTACT = 'mailerpress_contact';
    public const MAILERPRESS_CONTACT_NOTE = 'mailerpress_contact_note';
    public const CONTACT_TAGS = 'mailerpress_contact_tags';
    public const MAILERPRESS_EMAIL_BATCHES = 'mailerpress_email_batches';
    public const MAILERPRESS_TAGS = 'mailerpress_tags';
    public const MAILERPRESS_CONTACT_CUSTOM_FIELDS = 'mailerpress_contact_custom_fields';
    public const MAILERPRESS_EMAIL_QUEUE = 'mailerpress_email_queue';
    public const MAILERPRESS_CONTACT_BATCHES = 'mailerpress_contact_batches';
    public const MAILERPRESS_IMPORT_CONTACT_QUEUE = 'mailerpress_import_contact_queue';
    public const MAILERPRESS_IMPORT_CHUNKS = 'mailerpress_import_chunks';
    public const MAILERPRESS_LIST = 'mailerpress_lists';
    public const MAILERPRESS_CONTACT_LIST = 'mailerpress_contact_lists';
    public const MAILERPRESS_TEMPLATES = 'mailerpress_templates';
    public const MAILERPRESS_QUEUE_JOB = 'mailerpress_queue_job';
    public const MAILERPRESS_QUEUE_JOB_FAILURE = 'mailerpress_queue_job_failure';
    public const MAILERPRESS_AUTOMATIONS = 'mailerpress_automations';
    public const MAILERPRESS_AUTOMATIONS_STEPS = 'mailerpress_automations_steps';
    public const MAILERPRESS_AUTOMATIONS_STEP_LINKS = 'mailerpress_automations_steps_links';
    public const MAILERPRESS_AUTOMATIONS_CONTACT = 'mailerpress_automations_contact';
    public const MAILERPRESS_AUTOMATIONS_LOGS = 'mailerpress_automations_logs';
    public const MAILERPRESS_AUTOMATIONS_QUEUE = 'mailerpress_automations_queue';
    public const MAILERPRESS_PROVIDER_ACCOUNTS = 'mailerpress_provider_accounts';
    public const MAILERPRESS_PROVIDER_CONTACTS = 'mailerpress_provider_contacts';
    public const MAILERPRESS_PROVIDER_LISTS = 'mailerpress_provider_lists';
    public const MAILERPRESS_PROVIDER_TAGS = 'mailerpress_provider_tags';
    public const MAILERPRESS_SYNC_ERRORS = 'mailerpress_sync_errors';
    public const MAILERPRESS_CATEGORIES = 'mailerpress_categories';
    public const MAILERPRESS_SEGMENTS = 'mailerpress_segments';

    public static function getAll(): array
    {
        return [
            self::get(self::MAILERPRESS_EMAIL_BATCHES),
            self::get(self::CONTACT_TAGS),
            self::get(self::MAILERPRESS_CONTACT),
            self::get(self::MAILERPRESS_TAGS),
            self::get(self::MAILERPRESS_CONTACT_CUSTOM_FIELDS),
            self::get(self::MAILERPRESS_EMAIL_QUEUE),
            self::get(self::MAILERPRESS_CONTACT_BATCHES),
            self::get(self::MAILERPRESS_IMPORT_CONTACT_QUEUE),
            self::get(self::MAILERPRESS_IMPORT_CHUNKS),
            self::get(self::MAILERPRESS_LIST),
            self::get(self::MAILERPRESS_CONTACT_LIST),
            self::get(self::MAILERPRESS_TEMPLATES),
            self::get(self::MAILERPRESS_CAMPAIGNS),
            self::get(self::MAILERPRESS_QUEUE_JOB_FAILURE),
            self::get(self::MAILERPRESS_QUEUE_JOB),
            self::get(self::MAILERPRESS_QUEUE_JOB),
            self::get(self::MAILERPRESS_EMAIL_TRACKING),
        ];
    }

    /**
     * @param mixed $value
     *
     * @return string|void
     */
    public static function get($value): string
    {
        global $wpdb;

        if (!empty($value)) {
            return \sprintf('%s%s', $wpdb->prefix, $value);
        }

        return '';
    }
}
