<?php

namespace MailerPress\Actions\Frontend;

\defined('ABSPATH') || exit;

use MailerPress\Core\Attributes\Action;
use MailerPress\Core\Kernel;

class Frontend
{
    #[Action('wp_enqueue_scripts')]
    public function enqueue()
    {
        if (is_singular() && in_the_loop()) {
            return; // Avoid enqueueing too early
        }

        if (is_singular()) {
            global $post;

            if (has_shortcode($post->post_content, 'mailerpress_pages')) {
                wp_enqueue_style(
                    'mailerpress-shortcode-css',
                    Kernel::$config['rootUrl'] . '/build/public/shortcode.css',
                    [],
                    '1.0'
                );
            }
        }
    }
}