<?php

namespace MailerPress\Actions\ActionScheduler\Processors;

use MailerPress\Core\Attributes\Action;
use MailerPress\Core\Enums\Tables;

class AccessTokenGenerator
{
    #[Action('mailerpress_generate_access_tokens')]
    public function generateMissingTokens(): void
    {
        global $wpdb;
        $table = Tables::get(Tables::MAILERPRESS_CONTACT);

        // Batch size
        $batchSize = 200;

        // Fetch contacts missing access_token
        $contacts = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT contact_id FROM $table WHERE access_token IS NULL OR access_token = '' LIMIT %d",
                $batchSize
            )
        );

        if (empty($contacts)) {
            delete_option('mailerpress_access_tokens_scheduled');
            return;
        }

        foreach ($contacts as $contact) {
            $token = bin2hex(random_bytes(32));

            while ($wpdb->get_var($wpdb->prepare(
                    "SELECT COUNT(*) FROM $table WHERE access_token = %s",
                    $token
                )) > 0) {
                $token = bin2hex(random_bytes(32));
            }

            $wpdb->update(
                $table,
                ['access_token' => $token],
                ['contact_id' => $contact->contact_id],
                ['%s'],
                ['%d']
            );
        }

        // Reschedule this action to run again after 10 seconds
        if (function_exists('as_schedule_single_action')) {
            as_schedule_single_action(time() + 10, 'mailerpress_generate_access_tokens');
        }
    }
}