<?php

declare(strict_types=1);

namespace MailerPress\Actions\ActionScheduler;

\defined('ABSPATH') || exit;

use MailerPress\Core\Attributes\Action;
use MailerPress\Core\Attributes\Filter;

final class AsInit
{
    #[Action('init')]
    public function initCron(): void
    {
//        if (\function_exists('as_has_scheduled_action') && !as_has_scheduled_action('process_email_batch')) {
//            as_schedule_recurring_action(
//                time(),
//                1 * MINUTE_IN_SECONDS,
//                'process_email_batch',
//                [],
//                'daemon/mailerpress/batch'
//            );
//        }

        if (\function_exists('as_has_scheduled_action') && !as_has_scheduled_action('mailerpress_process_queue_worker')) {
            as_schedule_recurring_action(
                time(),
                1 * MINUTE_IN_SECONDS,
                'mailerpress_process_queue_worker',
                [],
                'daemon/mailerpress/process_queue_worker'
            );
        }

        if (\function_exists('as_next_scheduled_action') && !as_next_scheduled_action('mailerpress_as_clean')) {
            as_schedule_recurring_action(
                time(),
                WEEK_IN_SECONDS,
                'mailerpress_as_clean',
                [],
                'mailerpress'
            );
        }

        if (\function_exists('as_next_scheduled_action') && !as_next_scheduled_action('mailerpress_check_bounces')) {
            as_schedule_recurring_action(
                time(),
                15 * MINUTE_IN_SECONDS,
                'mailerpress_check_bounces'
            );

        }

        if (!get_option('mailerpress_access_tokens_scheduled',
                false) && !as_next_scheduled_action('mailerpress_generate_access_tokens')) {
            as_schedule_single_action(time(), 'mailerpress_generate_access_tokens');
            update_option('mailerpress_access_tokens_scheduled', true);
        }
    }

    #[Filter('action_scheduler_queue_runner_concurrent_batches')]
    public function mailerpress_increase_concurrent_batches($concurrent_batches)
    {
        return 1;
    }

    #[Filter('action_scheduler_queue_runner_batch_size')]
    public function mailerpress_increase_queue_batch_size($batch_size)
    {
        return 5;
    }

    #[Filter(['action_scheduler_timeout_period', 'action_scheduler_failure_period'])]
    public function mailerpress_increase_timeout($timeout)
    {
        return $timeout * 3;
    }

    #[Filter('action_scheduler_default_cleaner_statuses')]
    public function mailerpress_default_cleaner_statuses($statuses)
    {
        $statuses[] = 'failed';
        return $statuses;
    }

    #[Filter('action_scheduler_cleanup_batch_size')]
    public function mailerpress_cleanup_batch_size($batch_size)
    {
        return 100;
    }
}
