import {useBlockProps, RichText} from '@wordpress/block-editor';

export default function save({attributes}) {

    const blockProps = useBlockProps.save({
        style: {
            color: attributes.color || '#fff',
            padding: attributes.padding || '8px',
            borderRadius: attributes.borderRadius || '0px',
            fontSize: attributes.fontSize || 'small',
            width: attributes.buttonWidth > 0 ? `${attributes.buttonWidth}%` : 'auto',
        }
    });

    return (
        <div className="mailerpress-optin-form__submit">
            <button type="submit" {...blockProps}>
                <RichText.Content
                    tagName="span"
                    value={attributes.content || 'Submit'}
                />
            </button>
        </div>
    );
}
