<?php

class MailerPressProvider extends WPForms_Provider
{

    public function __construct()
    {
        $this->name = 'MailerPress';
        $this->slug = 'mailerpress-pro';
        $this->icon = plugin_dir_url(__FILE__) . 'assets/mailerpress-icon.svg'; // Optional
        $this->description = __('Add leads to your MailerPress list.', 'mailerpress-pro');
    }

    /**
     * Output the settings fields.
     */
    public function settings($settings, $form_data)
    {
        ?>
        <div class="wpforms-panel-content-section">

            <div class="wpforms-panel-field">
                <label for="wpforms-mailerpress-list"><?php _e('MailerPress List', 'mailerpress-pro'); ?></label>
                <select name="mailerpress_list" id="wpforms-mailerpress-list">
                    <?php foreach ($this->get_lists() as $id => $label): ?>
                        <option value="<?php echo esc_attr($id); ?>" <?php selected($settings['mailerpress_list'] ?? '',
                                $id); ?>>
                            <?php echo esc_html($label); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="wpforms-panel-field">
                <label><?php _e('Double Opt-in', 'mailerpress-pro'); ?></label>
                <label><input type="checkbox" name="mailerpress_double_optin"
                              value="1" <?php checked($settings['mailerpress_double_optin'] ?? '',
                            '1'); ?> /> <?php _e('Enable double opt-in', 'mailerpress-pro'); ?></label>
            </div>

        </div>
        <?php
    }

    /**
     * Called after form submission.
     */
    public function process($fields, $entry, $form_data)
    {

        $settings = $form_data['settings']['providers']['mailerpress-pro'] ?? [];

        if (empty($settings['mailerpress_list'])) {
            return;
        }

        $email = '';
        $first_name = '';
        $last_name = '';

        foreach ($fields as $field) {
            switch (strtolower($field['name'])) {
                case 'email':
                    $email = sanitize_email($field['value']);
                    break;
                case 'first name':
                    $first_name = sanitize_text_field($field['value']);
                    break;
                case 'last name':
                    $last_name = sanitize_text_field($field['value']);
                    break;
            }
        }

        $contact = [
                'contactEmail' => $email,
                'contactFirstName' => $first_name,
                'contactLastName' => $last_name,
                'lists' => [['id' => $settings['mailerpress_list']]],
                'tags' => [],
                'contactStatus' => $settings['mailerpress_double_optin'] ? 'pending' : 'subscribed',
                'opt_in_source' => 'wpforms',
                'optin_details' => json_encode([
                        'form_id' => $form_data['id'],
                        'entry_id' => $entry['entry_id'] ?? null,
                ]),
        ];

        add_mailerpress_contact($contact);
    }

    /**
     * Dummy method to fetch MailerPress lists — replace with real call.
     */
    private function get_lists()
    {
        // Replace with dynamic call
        return [
                'list_1' => 'Newsletter',
                'list_2' => 'Promotions',
        ];
    }
}
