<?php

namespace MailerPressPro\Services\ThirdParty;

use FluentForm\App\Services\Integrations\IntegrationManager;
use FluentForm\Framework\Foundation\Application;

abstract class MailerPressIntegration extends IntegrationManager
{
    public function __construct(Application $app)
    {
        parent::__construct(
            $app,
            'MailerPress',
            'mailerpress',
            'mailerpress_details',
            'mailerpress_feed',
            20
        );

        $this->description = 'Subscribe users via MailerPress API';
        $this->logo = plugin_dir_url(__FILE__) . 'assets/mailerpress-logo.png';
        $this->registerAdminHooks();
    }

    public function getGlobalFields()
    {
        return [
            'logo' => $this->logo,
            'menu_title' => __('MailerPress Settings', 'fluentform'),
            'menu_description' => __('Connect MailerPress API', 'fluentform'),
            'fields' => [
                'apiKey' => ['type' => 'text', 'label' => __('API Key', 'fluentform')],
                'listId' => ['type' => 'text', 'label' => __('List ID', 'fluentform')]
            ]
        ];
    }

    public function getSettingsFields($formId)
    {
        return [
            'listId' => [
                'type' => 'text',
                'label' => __('List ID', 'fluentform')
            ]
        ];
    }

    public function pushIntegration($settings, $formData, $submissionData)
    {
        // custom API call logic using settings['apiKey'] and settings from form
    }
}