<?php

namespace MailerPressPro\Core\Attributes;


#[\Attribute]
class Filter
{
    private string $scope;
    private string $actionName;
    private int $priority;
    private ?int $acceptedArgs;

    /**
     * @param string $actionName
     * @param string $scope
     * @param int $priority
     * @param int|null $acceptedArgs
     */
    public function __construct(string $actionName, string $scope = 'all', int $priority = 10, ?int $acceptedArgs = null)
    {
        $this->scope = $scope;
        $this->actionName = $actionName;
        $this->priority = $priority;
        $this->acceptedArgs = $acceptedArgs;
    }

    public function execute($callable): void
    {
        switch ($this->scope) {
            case 'front':
                if (!is_admin()) {
                    $this->launchAction($callable);
                }
                break;
            case 'admin':
                if (is_admin()) {
                    $this->launchAction($callable);
                }
                break;
            default:
                $this->launchAction($callable);
                break;
        }
    }

    private function launchAction($callable): void
    {
        if (!is_callable($callable)) {
            return;
        }

        if ($this->acceptedArgs) {
            add_filter($this->actionName, $callable, $this->priority, $this->acceptedArgs);
        } else {
            add_filter($this->actionName, $callable, $this->priority);
        }
    }

}
