<?php

namespace MailerPressPro\Actions\ThirdParty\FluentForm;

use MailerPressPro\Core\Attributes\Action;
use MailerPressPro\Core\Kernel;

class Setup
{
    #[Action('init')]
    public function registerMailerPressIntegration()
    {
        if (!defined('FLUENTFORM')) {
            return;
        }

        if (!defined('FLUENTFORM_FRAMEWORK_UPGRADE')) {
            return;
        }

        if (!function_exists('wpFluentForm')) {
            return;
        }

        require_once Kernel::$config['root'] . '/src/Services/ThirdParty/MailerPressFluentFormIntegration.php';
        $app = wpFluentForm();
        new \MailerPressPro\Services\ThirdParty\MailerPressFluentFormIntegration($app);
    }
}

