<?php

namespace MailerPressPro\Actions;

use DI\DependencyException;
use DI\NotFoundException;
use MailerPress\Core\Attributes\Filter;
use MailerPressPro\Core\Attributes\Action;
use MailerPressPro\Core\EmailManager\services\AmazonSES;
use MailerPressPro\Core\EmailManager\services\BrevoService;
use MailerPressPro\Core\EmailManager\services\GoogleMailService;
use MailerPressPro\Core\EmailManager\services\MailerPress;
use MailerPressPro\Core\EmailManager\services\MailerSend;
use MailerPressPro\Core\EmailManager\services\Mailgun;
use MailerPressPro\Core\EmailManager\services\Mailjet;
use MailerPressPro\Core\EmailManager\services\PostMark;
use MailerPressPro\Core\EmailManager\services\Resend;
use MailerPressPro\Core\EmailManager\services\SendGridService;
use MailerPressPro\Core\Kernel;

class Setup
{
    /**
     * @throws NotFoundException
     * @throws DependencyException
     * @throws \Exception
     */
    #[Action('init', priority: 100)]
    public function providers(): void
    {
        if (function_exists('mailerpress_get_provider_class')) {
            $providerClass = mailerpress_get_provider_class();
            $providerClass->registerService('brevo', Kernel::getContainer()->get(BrevoService::class));
            $providerClass->registerService('sendgrid', Kernel::getContainer()->get(SendGridService::class));
            $providerClass->registerService('gmail', Kernel::getContainer()->get(GoogleMailService::class));
            $providerClass->registerService('mailgun', Kernel::getContainer()->get(Mailgun::class));
            $providerClass->registerService('mailjet', Kernel::getContainer()->get(Mailjet::class));
            $providerClass->registerService('postmark', Kernel::getContainer()->get(PostMark::class));
            $providerClass->registerService('amazonses', Kernel::getContainer()->get(AmazonSES::class));
        }
    }

    #[Action('mailpress_enqueue_scripts')]
    public function enqueueScripts(): void
    {
        wp_enqueue_script('wp-icons');

        if (file_exists(Kernel::$config['root'] . '/build/dist/js/mailerpress-pro.asset.php')) {
            $asset_file = include(Kernel::$config['root'] . '/build/dist/js/mailerpress-pro.asset.php');
            wp_register_script(
                'mailerpress-pro',
                Kernel::$config['rootUrl'] . 'build/dist/js/mailerpress-pro.js',
                $asset_file['dependencies'],
                $asset_file['version'],
                ['in_footer' => true]
            );

            wp_set_script_translations(
                'mailerpress-pro',
                'mailerpress-pro',
                Kernel::$config['root'] . '/languages'
            );

            wp_enqueue_script('mailerpress-pro');


            wp_localize_script(
                'mailerpress-pro',
                'mailerpressPro',
                [
                    'currentVersion' => MAILERPRESS_PRO_VERSION,
                    'woo' => is_plugin_active('woocommerce/woocommerce.php'),
                    'pmpro' => function_exists('pmpro_hasMembershipLevel'),
                    'publicPath' => Kernel::$config['rootUrl'],
                ]
            );
        }

        if (file_exists(Kernel::$config['root'] . '/build/dist/js/mailerpress-pro-workflow.asset.php')) {
            $asset_file_2 = include(Kernel::$config['root'] . '/build/dist/js/mailerpress-pro-workflow.asset.php');
            wp_register_script(
                'mailerpress-pro-workflow',
                Kernel::$config['rootUrl'] . 'build/dist/js/mailerpress-pro-workflow.js',
                $asset_file_2['dependencies'],
                $asset_file_2['version'],
                ['in_footer' => true]
            );
        }

        if (file_exists(Kernel::$config['root'] . '/build/dist/css/mailerpress-pro-workflow.asset.php')) {
            $assetCssFile = include(Kernel::$config['root'] . '/build/dist/css/mailerpress-pro-workflow.asset.php');

            wp_enqueue_style(
                'malerpress-pro-css',
                Kernel::$config['rootUrl'] . 'build/dist/css/mailerpress-pro-workflow.css',
                ['wp-components'],
                $assetCssFile['version']
            );
        }
    }

    #[Filter('script_loader_tag', priority: 10, acceptedArgs: 3)]
    public function deferScript($tag, $handle, $src)
    {
        if (str_starts_with($handle, 'mailerpress-pro')) {
            // Use defer for execution after parsing
            return '<script src="' . esc_url($src) . '" defer></script>';
        }
        return $tag;
    }
}
