<?php

namespace MailerPressPro\Actions;

use MailerPressPro\Core\Attributes\Action;

class GmailConnect
{
    #[Action('admin_post_mailerpress_gmail_oauth_callback')]
    public function connect()
    {
        if (!current_user_can('manage_options')) {
            wp_die('Unauthorized');
        }

        // Try to get client_id/secret from POST first (when saving settings from React)
        $client_id     = sanitize_text_field($_POST['client_id'] ?? '');
        $client_secret = sanitize_text_field($_POST['client_secret'] ?? '');

        if ($client_id && $client_secret) {
            // Save them in Gmail-specific option for later reuse
            update_option('mailerpress_gmail_client', [
                'client_id'     => $client_id,
                'client_secret' => $client_secret,
            ]);
        } else {
            // Otherwise, pull from mailerpress_email_services option
            $services = get_option('mailerpress_email_services', []);
            if (!empty($services['services']['gmail']['conf'])) {
                $client_id     = $services['services']['gmail']['conf']['client_id'] ?? '';
                $client_secret = $services['services']['gmail']['conf']['client_secret'] ?? '';
            }

            // fallback to old storage
            if (empty($client_id) || empty($client_secret)) {
                $conf         = get_option('mailerpress_gmail_client', []);
                $client_id     = $conf['client_id'] ?? '';
                $client_secret = $conf['client_secret'] ?? '';
            }
        }

        if (empty($client_id) || empty($client_secret)) {
            wp_die('Missing Gmail client configuration.');
        }

        $redirect_uri = admin_url('admin-post.php?action=mailerpress_gmail_oauth_callback');

        // Handle OAuth callback
        if (!empty($_GET['code'])) {
            $code = sanitize_text_field($_GET['code']);

            $response = wp_remote_post('https://oauth2.googleapis.com/token', [
                'body' => [
                    'code'          => $code,
                    'client_id'     => $client_id,
                    'client_secret' => $client_secret,
                    'redirect_uri'  => $redirect_uri,
                    'grant_type'    => 'authorization_code',
                ],
            ]);

            if (!is_wp_error($response)) {
                $body = json_decode(wp_remote_retrieve_body($response), true);

                update_option('mailerpress_gmail_tokens', $body);

                wp_safe_redirect(
                    admin_url('admin.php?page=mailerpress%2Fcampaigns.php&path=%2Fhome%2Fsettings&activeView=Providers&googleconnected')
                );
                exit;
            } else {
                wp_die('Failed to connect Gmail: ' . $response->get_error_message());
            }
        }

        // Build OAuth URL
        $auth_url = add_query_arg([
            'client_id'     => $client_id,
            'redirect_uri'  => $redirect_uri,
            'response_type' => 'code',
            'scope'         => 'https://www.googleapis.com/auth/gmail.send https://www.googleapis.com/auth/userinfo.email',
            'access_type'   => 'offline',
            'prompt'        => 'consent',
        ], 'https://accounts.google.com/o/oauth2/v2/auth');

        wp_redirect($auth_url);
        exit;
    }
}
