<?php

namespace MailerPressPro\Services\AI;

use Exception;
use MailerPressPro\Abstract\AbstractAIService;
use MailerPressPro\Interfaces\AiModelInterface;

class MistralService extends AbstractAIService implements AiModelInterface
{

    public function generate(string $prompt, array $options = []): string
    {
        $body = $this->createRequestBody($prompt, $options);

        $response = wp_remote_post('https://api.mistral.ai/v1/chat/completions', [
            'headers' => [
                'Authorization' => 'Bearer ' . $this->api_key,
                'Content-Type' => 'application/json',
            ],
            'body' => wp_json_encode($body),
            'timeout' => 20,
        ]);

        if (is_wp_error($response)) {
            throw new Exception('Mistral Request Error: ' . $response->get_error_message());
        }

        $status_code = wp_remote_retrieve_response_code($response);
        $response_body = wp_remote_retrieve_body($response);
        $data = json_decode($response_body, true);

        if ($status_code !== 200 || empty($data['choices'][0]['message']['content'])) {
            throw new Exception('Invalid Mistral Response');
        }

        return trim($data['choices'][0]['message']['content']);
    }

    public function extractUsefulContent(string $response): string
    {
        // Extraire le texte entre les guillemets ou les ** **
        if (preg_match('/\*\*"?(.+?)"?\*\*/', $response, $matches)) {
            return trim($matches[1]);
        }

        // Fallback : essayer avec des guillemets simples si pas de markdown
        if (preg_match('/"(.+?)"/', $response, $matches)) {
            return trim($matches[1]);
        }

        // Dernier recours : retour brut
        return trim($response);
    }

}