<?php

namespace MailerPressPro\Core\Segmentation;

class SegmentRepository
{
    private string $table;

    public function __construct()
    {
        global $wpdb;
        $this->table = $wpdb->prefix . 'mailerpress_segments';
    }

    public function save(Segment $segment, string $name): void
    {
        global $wpdb;
        $data = [
            'name' => $name,
            'conditions' => wp_json_encode($this->serialize($segment)),
            'created_at' => current_time('mysql'),
        ];
        $wpdb->insert($this->table, $data);
    }

    private function serialize(Segment $segment): array
    {
        return [
            'operator' => $segment->getOperator(),
            'conditions' => array_map(fn($cond) => $cond->toSqlCondition(), $segment->getConditions()),
        ];
    }
}