<?php

namespace MailerPressPro\Core;


use MailerPressPro\Services\AI\Images\GeminiImageGenerator;
use MailerPressPro\Services\AI\Images\OpenAIImageGenerator;

class ImageGeneratorFactory
{
    public static function make(string $provider, array $config): ImageGeneratorInterface
    {
        // Only "openai" selects OpenAI, everything else defaults to Gemini
        if (strtolower($provider) === 'openai') {
            return new OpenAIImageGenerator(
                $config['apiKey'],
                $config['model'],
            );
        }

        return new GeminiImageGenerator(
            $config['apiKey'],
        );
    }
}

