<?php

namespace MailerPressPro\Api;

use DI\DependencyException;
use DI\NotFoundException;
use MailerPressPro\Core\Attributes\Endpoint;
use MailerPressPro\Core\Kernel;

class SyncTemplatePremium
{
    /**
     * @throws DependencyException
     * @throws NotFoundException
     */
    #[Endpoint('sync-premium-templates')]
    public function run(): \WP_Error|\WP_REST_Response|\WP_HTTP_Response
    {
        if (function_exists('mailerpress_templates_importer')) {
            mailerpress_templates_importer(
                Kernel::$config['root'] . '/templates'
            );
        }

        return rest_ensure_response('Templates synced successfully.');
    }
}