<?php

namespace MailerPressPro\Actions;

use DI\DependencyException;
use DI\NotFoundException;
use MailerPressPro\Core\Attributes\Action;
use MailerPressPro\Core\Kernel;

class TemplatesCategories
{
    /**
     * @throws DependencyException
     * @throws NotFoundException
     */
    #[Action('init')]
    public function templateImporter(): void
    {
        // 1️⃣ Schedule recurring action if not scheduled
        if (function_exists('as_next_scheduled_action') && !as_next_scheduled_action('wp_mailerpress_import_templates')) {
            as_schedule_recurring_action(
                time(),
                HOUR_IN_SECONDS,
                'wp_mailerpress_import_templates',
                [],
                'mailerpress'
            );
        }

        $storedVersion = get_option('mailerpress_pro_version');

        if (false === $storedVersion || $storedVersion !== MAILERPRESS_PRO_VERSION) {
            if (function_exists('mailerpress_templates_importer')) {
                mailerpress_templates_importer(Kernel::$config['root'] . '/templates');
            }

            update_option('mailerpress_pro_version', MAILERPRESS_PRO_VERSION);
        }

    }


    #[Action('wp_mailerpress_import_templates')]
    public function runImporter()
    {
        if (function_exists('mailerpress_templates_importer')) {
            mailerpress_templates_importer(
                Kernel::$config['root'] . '/templates'
            );
        }
    }
}