<?php

/**
 * Plugin Name: MailerPress Pro
 * Plugin URI: https://mailerpress.com
 * Description: The pro version of MailerPress plugin.
 * Version: 1.5.0
 * Author: Team MailerPress
 * Author URI: https://mailerpress.com
 * License: GPLv3 or later
 * Text Domain: mailerpress-pro
 * Domain Path: /languages
 * Requires PHP: 8.2
 * Requires at least: 6.5
 */

/*  Copyright 2025 - 2026 - Team MailerPress (email : contact@mailerpress.com)
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License, version 3, as
	published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

use MailerPressPro\Core\Kernel;
use MailerPressPro\Services\Activation;

define('MAILERPRESS_PRO_VERSION', '1.5.0');
define('MAILERPRESS_STORE_URL', 'https://mailerpress.com');
define('MAILERPRESS_PLUGIN_NAME', 'mailerpress-pro/mailerpress-pro.php');
define('MAILERPRESS_PRO_PLUGIN_FILE', __FILE__);


/** We can safely initialize the theme */
require_once __DIR__ . '/vendor/autoload.php';

try {
    Kernel::execute([
        'file' => __FILE__,
        'root' => __DIR__,
        'rootUrl' => plugin_dir_url(__FILE__)
    ]);

    // Check dependency on every admin page load
    add_action('admin_init', [Activation::class, 'checkDependency']);

    // Enqueue thickbox for plugin modal
    add_action('admin_enqueue_scripts', [Activation::class, 'enqueueScripts']);

    // Hooks for plugin requirements display
    add_action('admin_footer', [Activation::class, 'injectInlineNotice']);
    add_filter('plugin_row_meta', [Activation::class, 'addPluginRowMeta'], 10, 2);
    add_filter('plugin_action_links', [Activation::class, 'addPluginActionLinks'], 10, 2);

    register_activation_hook(__FILE__, function (): void {
        $activation = new Activation();
        $activation->activate();
        do_action('mailerpress_activation');
    });

    register_deactivation_hook(__FILE__, function (): void {
        do_action('mailerpress_deactivation');
    });

    // No uninstall hook - the free plugin handles deletion of both plugins
} catch (Exception $e) {
}
