<?php

namespace MailerPressPro\Services;

class WorkflowProcessor
{
    private int $workflowId;
    private array $nodes;

    public function __construct(int $workflowId)
    {
        global $wpdb;
        $this->workflowId = $workflowId;

        // Load all nodes for this workflow
        $this->nodes = $wpdb->get_results(
            $wpdb->prepare("SELECT * FROM wp_mailerpress_workflow_nodes WHERE workflow_id = %d", $workflowId),
            ARRAY_A
        );
    }

    public function start(int $triggerId, array $context = [])
    {
        $node = $this->getNodeById($triggerId);
        if (!$node || $node['type'] !== 'trigger') {
            return;
        }

        // Get the first action linked to the trigger
        if ($node['next_action_id']) {
            $this->executeAction($node['next_action_id'], $context);
        }
    }

    private function executeAction(int $actionId, array $context)
    {
        $node = $this->getNodeById($actionId);
        if (!$node || $node['type'] !== 'action') {
            return;
        }

        $data = json_decode($node['data'], true);
        $action = new Action($node['id'], $data);

        if ($action->hasDelay()) {
            // Schedule execution with delay
            $delaySeconds = $action->getDelayInSeconds();
            as_schedule_single_action(time() + $delaySeconds, 'mailerpress_execute_delayed_action',
                [$actionId, $context]);
        } else {
            // Execute immediately
            $action->runAction($context);
            if ($node['next_action_id']) {
                $this->executeAction($node['next_action_id'], $context);
            }
        }
    }

    private function getNodeById(int $id): ?array
    {
        foreach ($this->nodes as $node) {
            if ($node['id'] == $id) {
                return $node;
            }
        }
        return null;
    }
}
