<?php
namespace MailerPressPro\Services\ThirdParty;

class MailerPress_WPForms_Integration
{

    public function __construct()
    {
        // Hook your logic here, like saving API key, settings fields, etc.
        add_action('admin_init', [$this, 'maybe_save_settings']);
    }

    public function output()
    {
        // This is shown inside WPForms > Settings > Integrations > MailerPress
        echo '<p>Connect your MailerPress account to start syncing form entries.</p>';
        echo '<form method="post">';
        echo '<input type="text" name="mailerpress_api_key" value="' . esc_attr(get_option('mailerpress_api_key')) . '" />';
        echo '<input type="submit" class="button button-primary" value="Save API Key">';
        echo '</form>';
    }

    public function maybe_save_settings()
    {
        if (isset($_POST['mailerpress_api_key'])) {
            update_option('mailerpress_api_key', sanitize_text_field($_POST['mailerpress_api_key']));
        }
    }
}
