<?php
if (!defined('ABSPATH')) {
    exit;
}

GFForms::include_feed_addon_framework();

class MailerPressGfAddon extends GFFeedAddOn
{
    private static $_instance = null;
    protected $_version = '0.0.1';
    protected $_min_gravityforms_version = '1.9.12';
    protected $_slug = 'mailerpress';
    protected $_path = 'mailerpress/mailerpress.php';
    protected $_full_path = __FILE__;
    protected $_url = 'http://www.gravityforms.com';
    protected $_title = 'Gravity Forms MailerPress Add-On';
    protected $_short_title = 'MailerPress';
    protected $_enable_rg_autoupgrade = true;
    protected $_capabilities = array('gravityforms_mailerpress', 'gravityforms_mailerpress_uninstall');
    protected $_capabilities_settings_page = 'gravityforms_mailerpress';
    protected $_capabilities_form_settings = 'gravityforms_mailerpress';
    protected $_capabilities_uninstall = 'gravityforms_mailerpress_uninstall';

    public static function get_instance()
    {

        if (null === self::$_instance) {
            self::$_instance = new self;
        }

        return self::$_instance;

    }

    public function feed_settings_fields()
    {
        $settings = array(
            array(
                'title' => esc_html__('MailerPress Feed Settings', 'mailerpress'),
                'fields' => array(
                    array(
                        'name' => 'feed_name',
                        'label' => esc_html__('Name', 'mailerpress'),
                        'type' => 'text',
                        'required' => true,
                        'class' => 'medium',
                        'tooltip' => sprintf(
                            '<h6>%s</h6>%s',
                            esc_html__('Name', 'mailerpress'),
                            esc_html__('Enter a feed name to uniquely identify this setup.', 'mailerpress')
                        ),
                    ),
                    array(
                        'name' => 'mailerpress_list',
                        'label' => esc_html__('MailerPress List', 'mailerpress'),
                        'type' => 'select',
                        'choices' => $this->getMailerpressList(),
                        'required' => true,
                        'tooltip' => sprintf(
                            '<h6>%s</h6>%s',
                            esc_html__('MailerPress list', 'mailerpress'),
                            esc_html__('Select the MailerPress list you would like to add your contacts to.',
                                'mailerpress')
                        ),
                    ),
                    array(
                        'name' => 'mailerpress_tag',
                        'label' => esc_html__('MailerPress tag', 'mailerpress'),
                        'type' => 'select',
                        'choices' => $this->getMailerpressTags(),
                        'required' => false,
                        'tooltip' => sprintf(
                            '<h6>%s</h6>%s',
                            esc_html__('MailerPress List', 'mailerpress'),
                            esc_html__('Select the MailerPress tag you would like to add your contacts to.',
                                'mailerpress')
                        ),
                    ),
                    array(
                        'name' => 'options',
                        'label' => esc_html__('Options', 'mailerpress'),
                        'type' => 'checkbox',
                        'choices' => array(
                            array(
                                'name' => 'double_optin',
                                'label' => esc_html__('Double Opt-In', 'mailerpress'),
                                'default_value' => '1',
                                'value' => '1',
                                'onclick' => 'if(this.checked){jQuery("#mailerpress_doubleoptin_warning").hide();} else{jQuery("#mailerpress_doubleoptin_warning").show();}',
                                'tooltip' => sprintf(
                                    '<h6>%s</h6>%s',
                                    esc_html__('Double Opt-In', 'mailerpress'),
                                    esc_html__('When the double opt-in option is enabled, MailerPress will send a confirmation email to the user and will only add them to your MailerPress list upon confirmation.',
                                        'mailerpress')
                                ),
                            ),
                        ),
                    ),

                ),
            ),
            array(
                'dependency' => 'mailerpress_list',
                'fields' => array(
                    array(
                        'name' => 'mappedFields',
                        'label' => esc_html__('Map contact fields', 'mailerpress'),
                        'type' => 'field_map',
                        'field_map' => $this->merge_vars_field_map(),
                        'tooltip' => sprintf(
                            '<h6>%s</h6>%s',
                            esc_html__('Map Fields', 'mailerpress'),
                            esc_html__('Associate your MailerPress contact tags to the appropriate Gravity Form fields by selecting the appropriate form field from the list.',
                                'mailerpress')
                        ),
                    ),
                    array(
                        'name' => 'optinCondition',
                        'label' => esc_html__('Conditional Logic', 'gravityformsmailerpress'),
                        'type' => 'feed_condition',
                        'tooltip' => sprintf(
                            '<h6>%s</h6>%s',
                            esc_html__('Conditional Logic', 'gravityformsmailerpress'),
                            esc_html__('When conditional logic is enabled, form submissions will only be exported to MailerPress when the conditions are met. When disabled all form submissions will be exported.',
                                'gravityformsmailerpress')
                        ),
                    ),
                ),
            )
        );

        return $settings;
    }

    public function get_column_value_mailerpress_list_name($feed)
    {

        $lists = \MailerPress\Core\Kernel::getContainer()->get(\MailerPress\Models\Lists::class)->getLists();
        foreach ($lists as $list) {
            if ($list['list_id'] === rgar($feed['meta'], 'mailerpress_list')) {
                return $list['name'];
            }
        }
        return __('(No Name)', 'mailerpress');
    }

    public function get_column_value_mailerpress_list_tag($feed)
    {

        $tags = \MailerPress\Core\Kernel::getContainer()->get(\MailerPress\Models\Tags::class)->getAll();
        foreach ($tags as $tag) {
            if ($tag->tag_id === rgar($feed['meta'], 'mailerpress_tag')) {
                return $tag->name;
            }
        }
        return __('(No Name)', 'mailerpress');
    }


    public function get_column_value_feed_name($feed)
    {
        return rgar($feed['meta'], 'feed_name') ?: __('(No Name)', 'mailerpress');
    }

    public function feed_list_columns(): array
    {
        return array(
            'feed_name' => esc_html__('Name', 'mailerpress'),
            'mailerpress_list_name' => esc_html__('MailerPress List', 'mailerpress'),
            'mailerpress_list_tag' => esc_html__('MailerPress Tag', 'mailerpress'),
        );
    }

    public function merge_vars_field_map(): array
    {

        // Initialize field map array.
        $field_map = array(
            'email' => array(
                'name' => 'email',
                'label' => esc_html__('Email Address', 'mailerpress'),
                'required' => true,
                'field_type' => array('email', 'hidden'),
            ),
            'contactFirstName' => array(
                'name' => 'contactFirstName',
                'label' => esc_html__('First name', 'mailerpress'),
                'required' => false,
                'field_type' => array('name', 'hidden'),
            ),
            'contactLastName' => array(
                'name' => 'contactLastName',
                'label' => esc_html__('Last name', 'mailerpress'),
                'required' => false,
                'field_type' => array('name', 'hidden'),
            ),
        );


        return $field_map;
    }

    public function getMailerpressTags(): array
    {
        $tags = \MailerPress\Core\Kernel::getContainer()->get(\MailerPress\Models\Tags::class)->getAll();

        $formattedTags = array_map(function ($tag) {
            return [
                'label' => $tag->name,
                'value' => $tag->tag_id
            ];
        }, $tags);

        // Add default empty value
        array_unshift($formattedTags, [
            'label' => __('-- Select a tag --', 'mailerpress'),
            'value' => ''
        ]);

        return $formattedTags;
    }

    public function getMailerpressList(): array
    {
        $lists = \MailerPress\Core\Kernel::getContainer()->get(\MailerPress\Models\Lists::class)->getLists();

        $formattedLists = array_map(function ($list) {
            return [
                'label' => $list['name'],
                'value' => $list['list_id']
            ];
        }, $lists);

        // Add default empty value
        array_unshift($formattedLists, [
            'label' => __('-- Select a list --', 'mailerpress'),
            'value' => ''
        ]);

        return $formattedLists;
    }

    /**
     * @throws \DI\DependencyException
     * @throws \DI\NotFoundException
     */
    public function process_feed(
        $feed,
        $entry,
        $form
    ) {
        $subscriptionOption = get_option('mailerpress_signup_confirmation', null);
        if (null !== $subscriptionOption) {
            $subscriptionOption = json_decode($subscriptionOption, true);
        }
        $contact_data = [];
        $field_map = $this->get_field_map_fields($feed, 'mappedFields');
        $email = $this->get_field_value($form, $entry, $field_map['email']);
        $list = $feed['meta']['mailerpress_list'];
        $tag = $feed['meta']['mailerpress_tag'];
        $confirmOption = $feed['meta']['double_optin'];

        // If email address is invalid, log error and return.
        if (GFCommon::is_invalid_or_empty_email($email)) {
            $this->add_feed_error(
                esc_html__('A valid Email address must be provided.', 'mailerpress'),
                $feed,
                $entry, $form
            );
            return $entry;
        }


        $contact_data['contactEmail'] = $email;
        $contact_data['lists'] = [['id' => $list]];
        $contact_data['tags'] = [['id' => $tag]];
        if (false === $subscriptionOption['enableSignupConfirmation']) {
            $contact_data['contactStatus'] = 'subscribed';
        } else {
            $contact_data['contactStatus'] = $confirmOption === "1" ? 'pending' : 'subscribed';
        }
        $contact_data['opt_in_source'] = 'gravity_forms';
        $contact_data['optin_details'] = wp_json_encode([
            'form_id' => $form['id'],
            'form_title' => $form['title'],
            'entry_id' => $entry['id'],
        ]);

        $override_empty_fields = gf_apply_filters(
            'gform_mailerpress_override_empty_fields',
            array($form['id']),
            true,
            $form,
            $entry,
            $feed
        );

        // Log that empty fields will not be overridden.
        if (!$override_empty_fields) {
            $this->log_debug(__METHOD__ . '(): Empty fields will not be overridden.');
        }

        foreach ($field_map as $name => $field_id) {
            // If no field is mapped, skip it.
            if (rgblank($field_id)) {
                continue;
            }

            // Get field object.
            //$field = GFFormsModel::get_field($form, $field_id);
            $field_value = $this->get_field_value($form, $entry, $field_id);

            // If field value is empty and we are not overriding empty fields, skip it.
            if (empty($field_value) && (!$override_empty_fields)) {
                continue;
            }

            $contact_data[$name] = $field_value;
        }

        $result = add_mailerpress_contact($contact_data);


        if ($result['success']) {
            $this->add_note(
                $entry['id'],
                sprintf(
                    __('%s has been %s to MailerPress audience.', 'mailerpress'),
                    $email,
                    !empty($result['update']) ? 'updated' : 'added'
                ),
                'success',
            );
        } else {
            $this->add_feed_error(
                sprintf(
                    __('Unable to %s contact inside MailerPress. (%s)', 'mailerpress'),
                    $result['error'],
                    !empty($result['update']) ? 'update' : 'add'

                ),
                $feed,
                $entry,
                $form
            );
        }

    }

    public
    function feed_settings_page()
    {
        return true;
    }

    public function get_menu_icon()
    {

        return file_get_contents(\MailerPress\Core\Kernel::$config['root'] . '/build/public/images/mailerpress-logo.svg');

    }
}
