<?php

namespace MailerPressPro\Services\AI;

use Exception;
use MailerPressPro\Abstract\AbstractAIService;
use MailerPressPro\Interfaces\AiModelInterface;

class OpenAiService extends AbstractAIService implements AiModelInterface
{

    public function generate(string $prompt, array $options = []): string
    {
        $body = $this->createRequestBody($prompt, $options);

        $response = wp_remote_post('https://api.openai.com/v1/chat/completions', [
            'headers' => [
                'Authorization' => 'Bearer ' . $this->api_key,
                'Content-Type' => 'application/json',
            ],
            'body' => wp_json_encode($body),
            'timeout' => 20,
        ]);

        if (is_wp_error($response)) {
            throw new Exception('OpenAI Request Error: ' . $response->get_error_message());
        }

        $status_code = wp_remote_retrieve_response_code($response);
        $response_body = wp_remote_retrieve_body($response);
        $data = json_decode($response_body, true);

        if ($status_code !== 200 || empty($data['choices'][0]['message']['content'])) {
            throw new Exception('Invalid OpenAI Response');
        }

        return trim($data['choices'][0]['message']['content']);
    }
}