<?php

namespace MailerPressPro\Factories;

use Exception;
use MailerPressPro\Interfaces\AiModelInterface;
use MailerPressPro\Services\AI\DeepSeekService;
use MailerPressPro\Services\AI\GeminiService;
use MailerPressPro\Services\AI\MistralService;
use MailerPressPro\Services\AI\OpenAiService;

class AIFactory
{
    /**
     * @throws Exception
     */
    public static function make(): AiModelInterface
    {
        $provider = get_option('mailerpress_ai_model_settings', [
            'provider' => 'openai',
            'api_keys' => [
                'openai' => '',
                'deepseek' => '',
                'mistral' => '',
            ],
            'model' => 'gpt-4o',
            'max_tokens' => 2048,
        ]);

        if (is_string($provider)) {
            $provider = json_decode($provider, true);
        }

        if (
            !isset($provider['text_ai']) ||
            !isset($provider['text_ai']['provider'])
        ) {
            throw new Exception(__('Missing text_ai provider configuration', 'mailerpress'));
        }

        switch ($provider['text_ai']['provider']) {
            case 'openai':
                return new OpenAiService($provider['api_keys']['openai']);
            case 'gemini':
                return new GeminiService($provider['api_keys']['gemini']);
            case 'deepseek':
                return new DeepSeekService($provider['api_keys']['deepseek']); // You must implement it
            case 'mistral':
                return new MistralService(
                    $provider['api_keys']['mistral'],
                );
            default:
                throw new Exception('Unsupported AI provider');
        }
    }
}