<?php

namespace MailerPressPro\Core\Segmentation;

use MailerPressPro\Core\Segmentation\Conditions\CreatedAtCondition;
use MailerPressPro\Core\Segmentation\Conditions\UpdatedAtCondition;
use MailerPressPro\Core\Segmentation\Conditions\ListCondition;
use MailerPressPro\Core\Segmentation\Conditions\OpenEmailCondition;
use MailerPressPro\Core\Segmentation\Conditions\TagCondition;
use MailerPressPro\Core\Segmentation\Conditions\SubscriptionStatusCondition;
use MailerPressPro\Core\Segmentation\Conditions\WcPaidCustomer;

class ConditionFactory
{
    /**
     * Create a SegmentCondition object based on field and data
     *
     * @param array $conditionData ['field' => string, 'operator' => string, 'value' => mixed]
     * @return SegmentCondition
     * @throws \InvalidArgumentException
     */
    public static function create(array $conditionData): SegmentCondition
    {
        $field = $conditionData['field'] ?? '';
        $operator = $conditionData['operator'] ?? '';
        $value = $conditionData['value'] ?? null;

        return match ($field) {
            'list' => new ListCondition($value, $operator),
            'tag' => new TagCondition($value, $operator),
            'subscription_status' => new SubscriptionStatusCondition($value, $operator),
            'created_at' => new CreatedAtCondition( $operator, $value),
            'updated_at' => new UpdatedAtCondition($operator, $value),
            'openers' => new OpenEmailCondition($value, $operator),
            'wc_paid_customer' => new WcPaidCustomer($value, $operator),
            default => throw new \InvalidArgumentException("Unknown condition field: {$field}"),
        };
    }
}