<?php

namespace MailerPressPro\Core\Automation\Triggers;

use MailerPressPro\Core\Automation\AutomationContainer;

class NewSubscriberTrigger
{
    public function register(): void
    {
        AutomationContainer::register_trigger('new_subscriber', [
            'label' => 'New Subscriber',
            'description' => 'Triggered when a new user subscribes to the newsletter.',
            'parameters' => [
                ['name' => 'email', 'type' => 'string'],
                ['name' => 'first_name', 'type' => 'string']
            ]
        ]);
    }

    public function execute(array $params): void
    {
        // This method is called when the trigger is fired.
        // You can process the subscriber data here, e.g., send an email or create a campaign.
        $email = $params['email'];
        $first_name = $params['first_name'];

        // Example: Send a welcome email to the new subscriber
        wp_mail(
            $email,
            'Welcome to our newsletter!',
            'Hello ' . $first_name . ', thank you for subscribing to our newsletter!'
        );

        // Example: You could also schedule additional actions, etc.
    }
}
