<?php

namespace MailerPressPro\Core\Automation;

class AutomationContainer
{
    private static array $triggers = [];
    private static array $actions = [];
    private static array $timers = [];

    /** Register a new trigger */
    public static function register_trigger(string $key, array $config): void
    {
        self::$triggers[$key] = $config;
    }

    /** Register a new action */
    public static function register_action(string $key, array $config): void
    {
        self::$actions[$key] = $config;
    }

    /** Register a timer */
    public static function register_timer(string $key, array $config): void
    {
        self::$timers[$key] = $config;
    }

    /** Get all registered triggers */
    public static function get_triggers(): array
    {
        return apply_filters('mailerpress_automation_triggers', self::$triggers);
    }

    /** Get all registered actions */
    public static function get_actions(): array
    {
        return apply_filters('mailerpress_automation_actions', self::$actions);
    }

    /** Get all registered timers */
    public static function get_timers(): array
    {
        return apply_filters('mailerpress_automation_timers', self::$timers);
    }
}
