<?php

namespace MailerPressPro\Core\Automation\Actions;

use MailerPressPro\Core\Automation\AutomationContainer;

class DelayAction
{
    public function register(): void
    {
        AutomationContainer::register_action('delay', [
            'label' => 'Delay',
            'description' => 'Pauses execution for a specified duration before proceeding.',
            'parameters' => [
                ['name' => 'delay_seconds', 'type' => 'integer']
            ]
        ]);
    }

    public function execute(array $params): void
    {
        wp_schedule_single_event(
            time() + $params['delay_seconds'],
            'execute_automation_node',
            [
                $params['next_node'],
                $params['contact_id']
            ]
        );
    }
}
