<?php

namespace MailerPressPro\Automation\Utils;

use MailerPress\Core\Enums\Tables;

class AutomationRepository
{
    public function hasActiveAutomation($automation_id, $contact_id)
    {
        if (class_exists(Tables::class)) {

            global $wpdb;
            $table = Tables::get(Tables::MAILERPRESS_AUTOMATIONS_CONTACT);
            return $wpdb->get_var($wpdb->prepare(
                "SELECT id FROM $table WHERE automation_id = %d AND contact_id = %d",
                $automation_id,
                $contact_id
            ));
        }
    }

    public function addAutomationContact($automation_id, $contact_id)
    {
        if (class_exists(Tables::class)) {

            global $wpdb;
            $table = Tables::get(Tables::MAILERPRESS_AUTOMATIONS_CONTACT);

            $wpdb->insert($table, [
                'automation_id' => $automation_id,
                'contact_id' => $contact_id,
                'status' => 'running',
                'started_at' => current_time('mysql')
            ]);
        }
    }

    public function getFirstStep($automation_id)
    {
        if (class_exists(Tables::class)) {

            global $wpdb;
            $table = Tables::get(Tables::MAILERPRESS_AUTOMATIONS_STEPS);
            return $wpdb->get_row($wpdb->prepare(
                "SELECT * FROM $table WHERE automation_id = %d ORDER BY step_order ASC LIMIT 1",
                $automation_id
            ));
        }
    }

    public function getStep($step_id)
    {
        if (class_exists(Tables::class)) {
            global $wpdb;
            $table = Tables::get(Tables::MAILERPRESS_AUTOMATIONS_STEPS);
            return $wpdb->get_row($wpdb->prepare(
                "SELECT * FROM $table WHERE step_id = %d",
                intval($step_id)
            ));
        }
    }

    public function getNextSteps($step_id)
    {
        if (class_exists(Tables::class)) {
            global $wpdb;
            $table = Tables::get(Tables::MAILERPRESS_AUTOMATIONS_STEP_LINKS);
            $tabjeJoin = Tables::get(Tables::MAILERPRESS_AUTOMATIONS_STEPS);
            return $wpdb->get_results($wpdb->prepare(
                "SELECT s.* FROM $table l
             JOIN $tabjeJoin s ON s.step_id = l.to_step_id
             WHERE l.from_step_id = %d",
                intval($step_id)
            ));
        }
    }

    public function getNextStepForBranch($step_id, $branch)
    {
        if (class_exists(Tables::class)) {
            global $wpdb;
            $table = Tables::get(Tables::MAILERPRESS_AUTOMATIONS_STEP_LINKS);
            $tabjeJoin = Tables::get(Tables::MAILERPRESS_AUTOMATIONS_STEPS);
            return $wpdb->get_row($wpdb->prepare(
                "SELECT s.* FROM $table l
             JOIN $tabjeJoin s ON s.step_id = l.to_step_id
             WHERE l.from_step_id = %d AND l.condition_branch = %s",
                $step_id, $branch
            ));
        }
    }

    public function queueDelayedStep($automation_id, $contact_id, $step_id, $run_at)
    {
        if (class_exists(Tables::class)) {

            global $wpdb;
            $table = Tables::get(Tables::MAILERPRESS_AUTOMATIONS_QUEUE);

            $wpdb->insert($table, [
                'automation_id' => $automation_id,
                'contact_id' => $contact_id,
                'step_id' => $step_id,
                'run_at' => date('Y-m-d H:i:s', $run_at),
                'status' => 'pending'
            ]);
        }
    }

    public function getAutomationsForTrigger($type, $params)
    {
        if (class_exists(Tables::class)) {
            global $wpdb;
            $like_tag = isset($params['tag']) ? '%' . $wpdb->esc_like($params['tag']) . '%' : '%';
            $table = Tables::get(Tables::MAILERPRESS_AUTOMATIONS);

            return $wpdb->get_results($wpdb->prepare(
                "SELECT * FROM $table WHERE trigger_type = %s",
                $type
            ));
        }
    }
}