<?php

namespace MailerPressPro\Automation\Utils;

use MailerPress\Core\Enums\Tables;

class AutomationLogger
{
    public function logSuccess($automation_id, $contact_id, $step_id)
    {
        global $wpdb;
        $table = Tables::get(Tables::MAILERPRESS_AUTOMATIONS_LOGS);
        $wpdb->insert($table, [
            'automation_id' => $automation_id,
            'contact_id' => $contact_id,
            'step_id' => $step_id,
            'status' => 'success',
            'executed_at' => current_time('mysql')
        ]);
    }

    public function logError($automation_id, $contact_id, $step_id, $message)
    {
        global $wpdb;
        $table = Tables::get(Tables::MAILERPRESS_AUTOMATIONS_LOGS);

        $wpdb->insert($table, [
            'automation_id' => $automation_id,
            'contact_id' => $contact_id,
            'step_id' => $step_id,
            'status' => 'error',
            'executed_at' => current_time('mysql'),
            'message' => $message
        ]);
    }
}