<?php

namespace MailerPressPro\Automation\Engine;

use MailerPressPro\Automation\Steps\AutomationStepExecutor;
use MailerPressPro\Automation\Utils\AutomationLogger;
use MailerPressPro\Automation\Utils\AutomationRepository;

class AutomationEngine
{
    protected $repository;
    protected $executor;
    protected $logger;

    public function __construct()
    {
        $this->repository = new AutomationRepository();
        $this->executor = new AutomationStepExecutor();
        $this->logger = new AutomationLogger();
    }

    public function startAutomation($automation_id, $contact_id)
    {
        if ($this->repository->hasActiveAutomation($automation_id, $contact_id)) {
            return;
        }

        $this->repository->addAutomationContact($automation_id, $contact_id);
        $first_step = $this->repository->getFirstStep($automation_id);

        $this->executeStep($automation_id, $contact_id, $first_step->step_id);
    }

    public function executeStep($automation_id, $contact_id, $step_id)
    {
        $step = $this->repository->getStep($step_id);

        try {
            $result = $this->executor->handle($step, $contact_id, $automation_id);

            $this->logger->logSuccess($automation_id, $contact_id, $step_id);

            if ($result === 'wait') {
                return;
            }

            $next_steps = $this->repository->getNextSteps($step_id);
            foreach ($next_steps as $next) {
                $this->executeStep($automation_id, $contact_id, $next->step_id);
            }
        } catch (\Exception $e) {
            $this->logger->logError($automation_id, $contact_id, $step_id, $e->getMessage());
        }
    }
}