<?php

namespace MailerPressPro\Api;

use Exception;
use MailerPressPro\Core\Attributes\Endpoint;
use MailerPressPro\Factories\AIFactory;
use WP_REST_Request;
use WP_REST_Response;

class Gpt
{
    #[Endpoint(
        'generate-text',
        methods: 'POST',
        permissionCallback: [Permissions::class, 'canEdit'],
    )]
    public function generateTextAi(WP_REST_Request $request): WP_REST_Response
    {
        $prompt = trim($request->get_param('prompt') ?? '');
        if (empty($prompt)) {
            return new WP_REST_Response(['error' => 'Missing prompt'], 400);
        }

        try {
            $aiService = AIFactory::make();
            $provider = get_option('mailerpress_ai_model_settings', [
                'provider' => 'openai',
                'api_keys' => [
                    'openai' => '',
                    'deepseek' => '',
                    'mistral' => '',
                ],
                'model' => 'gpt-4o',
                'max_tokens' => 2048,
            ]);

            if (is_string($provider)) {
                $provider = json_decode($provider, true);
            }

            $text = $aiService->generate($prompt, $provider);
            return new WP_REST_Response(['text' => $text], 200);
        } catch (Exception $e) {
            error_log($e->getMessage());
            return new WP_REST_Response([
                'error' => 'AI service error',
                'message' => $e->getMessage(),
            ], 500);
        }
    }

    #[Endpoint(
        'text-suggestion',
        methods: 'POST',
        permissionCallback: [Permissions::class, 'canEdit'],
    )]
    public function suggestTextAi(WP_REST_Request $request): WP_REST_Response
    {
        $prompt = trim($request->get_param('prompt') ?? '');
        $limit  = (int) $request->get_param('limit') ?? 3; // number of suggestions

        if (empty($prompt)) {
            return new WP_REST_Response(['error' => 'Missing prompt'], 400);
        }

        try {
            $aiService = AIFactory::make();

            $provider = get_option('mailerpress_ai_model_settings', [
                'provider' => 'openai',
                'api_keys' => [
                    'openai'   => '',
                    'deepseek' => '',
                    'mistral'  => '',
                ],
                'model'      => 'gpt-4o',
                'max_tokens' => 2048,
            ]);

            if (is_string($provider)) {
                $provider = json_decode($provider, true);
            }


            // Call the new suggest method
            $suggestions = $aiService->suggest($prompt, $provider, $limit);

            return new WP_REST_Response([
                'suggestions' => $suggestions,
            ], 200);

        } catch (Exception $e) {
            error_log($e->getMessage());
            return new WP_REST_Response([
                'error'   => 'AI service error',
                'message' => $e->getMessage(),
            ], 500);
        }
    }

}