<?php

namespace MailerPressPro\Actions;

use MailerPressPro\Core\Attributes\Action;
use MailerPressPro\Core\Attributes\Filter;
use MailerPressPro\Services\MailerPressLicence;

class UpdateManager
{
    #[Action('site_transient_update_plugins')]
    public function injectUpdate($transient)
    {
        if (empty($transient->checked)) {
            return $transient;
        }

        if (!current_user_can('update_plugins')) {
            return $transient;
        }

        $pluginFile = 'mailerpress-pro/mailerpress-pro.php';
        $currentVersion = $transient->checked[$pluginFile] ?? '0.0.0';

        // Use transient cache
        $result = get_transient('mailerpress_update_info');

        if (false === $result) {
            $license = MailerPressLicence::instance();
            $result = $license->check_for_update();
            set_transient('mailerpress_update_info', $result, 12 * HOUR_IN_SECONDS);
        }

        if (is_wp_error($result) || empty($result['data']['package']['new_version'])) {
            return $transient;
        }

        $newVersion = $result['data']['package']['new_version'];

        if (version_compare($newVersion, $currentVersion, '<=')) {
            return $transient;
        }

        $plugin_info = (object)[
            'slug' => $result['data']['package']['slug'] ?? 'mailerpress-pro',
            'plugin' => $pluginFile,
            'new_version' => $newVersion,
            'url' => $result['data']['package']['url'] ?? 'https://mailerpress.com',
            'package' => $result['data']['package']['package'] ?? '',
        ];

        $transient->response[$pluginFile] = $plugin_info;

        return $transient;
    }


    #[Action('plugins_api', acceptedArgs: 3)]
    public function pluginsApi($false, $action, $args)
    {
        // Only intercept info requests for our plugin
        if ($action !== 'plugin_information' || empty($args->slug) || $args->slug !== 'mailerpress-pro') {
            return $false;
        }

        $license = MailerPressLicence::instance();
        $result = $license->check_for_update();

        if (is_wp_error($result)) {
            return $false;
        }

        $package = $result['data']['package'] ?? [];

        if (empty($package)) {
            return $false;
        }

        // Build plugin info object for WordPress
        $plugin_info = (object)[
            'name' => 'MailerPress Pro',
            'slug' => $package['slug'] ?? 'mailerpress-pro',
            'version' => $package['new_version'] ?? '0.0.0',
            'author' => 'MailerPress',
            'homepage' => $package['url'] ?? 'https://mailerpress.com',
            'requires' => '6.0', // minimum WordPress version
            'tested' => $package['tested'] ?? '6.8',
            'download_link' => $package['package'] ?? '', // link to zip
            'sections' => [
                'description' => 'MailerPress Pro — Premium plugin for newsletters and email marketing.',
                'changelog' => $package['upgrade_notice'] ?? '',
            ],
        ];

        return $plugin_info;
    }

}