<?php

namespace MailerPressPro\Actions\ThirdParty\WooCommerce;

use DI\DependencyException;
use DI\NotFoundException;
use Exception;
use MailerPressPro\Core\Attributes\Action;
use Automattic\WooCommerce\Blocks\Package;
use Automattic\WooCommerce\Blocks\Domain\Services\CheckoutFields;

class CheckoutField
{
    #[Action('woocommerce_init')]
    public function mailerPress_checkout_field()
    {
        $mailerpress_settings = get_option('woocommerce_mailerpress_settings');

        if (is_string($mailerpress_settings)) {
            $mailerpress_settings = json_decode($mailerpress_settings, true);
        }


        if (false === $mailerpress_settings || empty($mailerpress_settings['enable_checkout_optin'])) {
            return;
        }

        // Safety: make sure the helper exists (older WooCommerce won’t have it).
        if (!function_exists('woocommerce_register_additional_checkout_field')) {
            return;
        }

        try {
            woocommerce_register_additional_checkout_field(
                array(
                    'id' => 'mailerpress/subscribe',
                    'label' => $mailerpress_settings['subscribe_label'] ?? __('Subscribe to our newsletter',
                            'mailerpress'),
                    'location' => $mailerpress_settings['location'] ?? 'contact',
                    'type' => 'checkbox',
                    'required' => false,
                    'description' => __('Occasional product news & special offers. Unsubscribe anytime.',
                        'mailerpress'),
                )
            );
        } catch (\Exception $e) {

        }
    }

    /**
     * @throws \Exception
     */
    #[Action('woocommerce_thankyou', acceptedArgs: 1)]
    public function mailepress_optin($order_id)
    {
        $field_id = 'mailerpress/subscribe';
        error_log("[MailerPress] Processing WooCommerce order ID: $order_id");

        // Grab the WC_Order.
        /** @var \WC_Order $order */
        $order = wc_get_order($order_id);

        if (!$order) {
            error_log("[MailerPress] Invalid order: $order_id");
            return;
        }

        // Get the CheckoutFields service from the Blocks DI container.
        $checkout_fields = Package::container()->get(CheckoutFields::class);

        // For non-address fields (contact & order locations), use group 'other'.
        $opt_in = (bool)$checkout_fields->get_field_from_object($field_id, $order, 'other');

        if ($opt_in) {
            $email = $order->get_billing_email();
            $first_name = $order->get_billing_first_name();
            $last_name = $order->get_billing_last_name();

            error_log($first_name . " " . $last_name . " " . $email);

            $mailerpress_settings = get_option('woocommerce_mailerpress_settings');

            if (is_string($mailerpress_settings)) {
                $mailerpress_settings = json_decode($mailerpress_settings, true);
            }

            if (!empty($email)) {
                $contact_data['opt_in_source'] = 'woocommerce';
                $contact_data['contactEmail'] = $email;
                $contact_data['contactFirstName'] = $first_name ?: '';
                $contact_data['contactLastName'] = $last_name ?: '';
                $contact_data['tags'] = array_map(function ($id) {
                    return ['id' => $id];
                }, $mailerpress_settings['subscribe_tags'] ?? []);
                $contact_data['lists'] = array_map(function ($id) {
                    return ['id' => $id];
                }, $mailerpress_settings['subscribe_lists'] ?? []);

                try {
                    add_mailerpress_contact($contact_data);
                } catch (DependencyException $e) {
                    error_log("[MailerPress] DependencyException: " . $e->getMessage());
                } catch (NotFoundException $e) {
                    error_log("[MailerPress] NotFoundException: " . $e->getMessage());
                } catch (Exception $e) {
                    error_log("[MailerPress] General Exception: " . $e->getMessage());
                }
            } else {
                error_log("[MailerPress] No email found for order ID $order_id");
            }
        }
    }

}