<?php

namespace MailerPressPro\Actions\ThirdParty\PmPro;

use MailerPressPro\Core\Attributes\Action;
use MailerPressPro\Core\Attributes\Filter;

class Setup
{
    #[Action('pmpro_checkout_before_submit_button')]
    public function maybeShopOptin(): void
    {
        $pmproSetting = get_option('pmpro_mailerpress_settings');
        if (is_string($pmproSetting)) {
            $pmproSetting = json_decode($pmproSetting, true);
        }


        if (false === $pmproSetting || $pmproSetting['enable_checkout_optin'] !== true) {
            return;
        }

        $label = $pmproSetting['subscribe_label'];
        $checked = !empty($_REQUEST['mailerpress-nl']); // keep checked if form reloaded

        ?>
        <div class="pmpro_checkout-field pmpro_checkout-field-subscribe">
            <label for="mailerpress-nl" class="pmpro_label-inline">
                <input
                        id="mailerpress-nl"
                        type="checkbox"
                        class="<?php echo esc_attr(pmpro_get_element_class('input', 'mailerpress-nl')); ?>"
                        name="mailerpress-nl"
                        value="1"
                        <?php checked($checked); ?>
                />
                <?php echo esc_html($label); ?>
            </label>
        </div>
        <?php
    }

    #[Action('pmpro_after_checkout', priority: 15)]
    public function addSubscriberAndAttachToOrder($user_id)
    {

        // Check if user opted in
        $opt_in = !empty($_REQUEST['mailerpress-nl']);
        if (!$opt_in) {
            error_log("[MailerPress] User did not opt in: {$user_id}");
            return;
        }

        $user = get_userdata($user_id);
        if (!$user) {
            error_log("[MailerPress] Invalid user ID: $user_id");
            return;
        }

        $email = $user->user_email;
        $first_name = $user->first_name;
        $last_name = $user->last_name;

        $mailerpress_settings = get_option('pmpro_mailerpress_settings', []);
        if (is_string($mailerpress_settings)) {
            $mailerpress_settings = json_decode($mailerpress_settings, true);
        }

        if (!empty($email)) {
            $contact_data = [
                    'opt_in_source' => 'pmpro',
                    'contactEmail' => $email,
                    'contactFirstName' => $first_name ?: '',
                    'contactLastName' => $last_name ?: '',
                    'tags' => array_map(fn($id) => ['id' => $id], $mailerpress_settings['subscribe_tags'] ?? []),
                    'lists' => array_map(fn($id) => ['id' => $id], $mailerpress_settings['subscribe_lists'] ?? []),
            ];

            try {
                $contact_id = add_mailerpress_contact($contact_data);

                update_user_meta($user_id, '_mailerpress_sync', $contact_id);

                error_log("[MailerPress] Contact added and linked to order {$order->id}: {$email}");
            } catch (\Exception $e) {
                error_log("[MailerPress] Exception: " . $e->getMessage());
            }
        } else {
            error_log("[MailerPress] No email found for user ID $user_id");
        }
    }

    //#[Action('pmpro_after_order_settings_table')]
    public function displayMailerPressStatus($order)
    {
        // Get MailerPress contact ID from order meta
        $contact_id = get_post_meta($order->id, '_mailerpress_contact_id', true);

        ?>
        <div class="pmpro_section">
            <div class="pmpro_section_toggle">
                <button class="pmpro_section-toggle-button" type="button" aria-expanded="true">
                    <span class="dashicons dashicons-arrow-up-alt2"></span>
                    MailerPress Status
                </button>
            </div>
            <div class="pmpro_section_inside">
                <?php
                if (!empty($contact_id)) {
                    echo '<p><strong>MailerPress:</strong> Contact successfully added (ID: ' . esc_html($contact_id) . ')</p>';

                    // Optional: show subscribed lists
                    global $wpdb;
                    $lists = $wpdb->get_results(
                            $wpdb->prepare(
                                    "SELECT ml.name 
                         FROM {$wpdb->prefix}mailerpress_list ml
                         INNER JOIN {$wpdb->prefix}mailerpress_contact_list mcl 
                         ON ml.id = mcl.list_id 
                         WHERE mcl.contact_id = %d",
                                    $contact_id
                            )
                    );

                    if (!empty($lists)) {
                        echo '<p><strong>Subscribed Lists:</strong></p><ul>';
                        foreach ($lists as $list) {
                            echo '<li>' . esc_html($list->name) . '</li>';
                        }
                        echo '</ul>';
                    } else {
                        echo '<p><em>Not subscribed to any lists.</em></p>';
                    }

                } else {
                    echo '<p><em>Contact not found in MailerPress.</em></p>';
                }
                ?>
            </div>
        </div>
        <?php
    }

    #[Filter('pmpro_member_edit_panels')]
    public function memberPanel($panels)
    {
        // Add new panel to panels array
        if (class_exists('\MailerPressPro\Services\MailerPressPanel')) {
            $panels[] = new \MailerPressPro\Services\MailerPressPanel();
        }

        return $panels;
    }

}
