<?php

namespace MailerPressPro\Actions;

use MailerPressPro\Core\Attributes\Action;
use MailerPressPro\Core\Kernel;

class Licencing
{
    #[Action('admin_notices', priority: 10)]
    public function noticeLicenceActivation()
    {
        $whiteLabel = apply_filters('mailerpress_white_label_options', [
                'white_label_active' => false,
        ]);

        if (!get_option('mailerpress_license_activated') && false === $whiteLabel['white_label_active']) {
            ?>
            <div class="notice notice-warning is-dismissible">
                <p>
                    <strong><?php echo esc_html__('MailerPress Pro:', 'mailerpress'); ?></strong>
                    <?php echo esc_html__('Please activate your license to unlock all Pro features and receive automatic updates.', 'mailerpress'); ?>
                </p>
                <p>
                    <a href="<?php echo esc_url(admin_url('admin.php?page=mailerpress%2Fcampaigns.php&path=%2Fhome%2Fsettings&activeView=Licence')); ?>"
                       class="button button-primary">
                        <?php echo esc_html__('Activate License', 'mailerpress'); ?>
                    </a>
                </p>
            </div>
            <?php
        }
    }

}