<?php

namespace MailerPressPro\Actions\Automation\Triggers;

use MailerPressPro\Automation\AutomationTriggerRegistry;
use MailerPressPro\Automation\Engine\AutomationEngine;
use MailerPressPro\Automation\Utils\AutomationRepository;
use MailerPressPro\Core\Attributes\Action;

class TagAdded
{
    private AutomationEngine $automation_engine;
    private AutomationRepository $repository;

    /**
     * @param AutomationEngine $automation_engine
     * @param AutomationRepository $repository
     */
    public function __construct(AutomationEngine $automation_engine, AutomationRepository $repository)
    {
        $this->automation_engine = $automation_engine;
        $this->repository = $repository;
    }

    #[Action('init', priority: 1)]
    public function register(): void
    {
        AutomationTriggerRegistry::register('tag_added', function () {
            add_action('mailerpress/contact_tag_added', function ($contact_id, $tag) {
                $automations = $this->repository->getAutomationsForTrigger('tag_added', ['tag' => $tag]);

                if (!empty($automations)) {
                    foreach ($automations as $automation) {
                        $this->automation_engine->startAutomation(
                            $automation->automation_id,
                            $contact_id
                        );
                    }
                }
            }, 10, 2);
        });
    }
}