<?php

/**
 * Plugin Name: MailerPress Pro
 * Plugin URI: https://www.mailerpress.com/
 * Description: The pro version of MailerPress plugin.
 * Version: 1.0
 * Author: Team MailerPress
 * Author URI: https://www.mailerpress.com/
 * License: GPLv3 or later
 * Text Domain: mailerpress-pro
 * Domain Path: /languages
 * Requires PHP: 8.2.0
 * Requires at least: 6.5.0
 */

/*  Copyright 2025 - Team MailerPress (email : contact@mailerpress.com)
	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License, version 3, as
	published by the Free Software Foundation.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

use MailerPressPro\Core\Kernel;
use MailerPressPro\Services\Activation;

define('MAILERPRESS_PRO_VERSION', '1.0');
define('MAILERPRESS_STORE_URL', 'https://mailerpress.com/');
define('MAILERPRESS_PLUGIN_NAME', 'mailerpress-pro/mailerpress-pro.php');


/** We can safely initialize the theme */
require_once __DIR__ . '/vendor/autoload.php';

try {
    Kernel::execute([
        'file' => __FILE__,
        'root' => __DIR__,
        'rootUrl' => plugin_dir_url(__FILE__)
    ]);


    register_activation_hook(__FILE__, function (): void {
        $activation = new Activation();
        $activation->activate();
        do_action('mailerpress_activation');
    });

    register_deactivation_hook(__FILE__, function (): void {
        do_action('mailerpress_deactivation');
    });

    register_uninstall_hook(__FILE__, function (): void {
        do_action('mailerpress_uninstall');
    });

} catch (Exception $e) {
}