<?php

namespace MailerPressPro\Services;

if (!class_exists('PMPro_Member_Edit_Panel')) {
    // PMPro not active
    return;
}

class MailerPressPanel extends \PMPro_Member_Edit_Panel
{
    public function __construct()
    {
        $this->slug = 'mailerpress-info';
        $this->title = __('MailerPress', 'mailerpress-pro');
    }

    protected function display_panel_contents()
    {
        $user = self::get_user();
        $mailerpress_sync = get_user_meta($user->ID, '_mailerpress_sync', true);
        ?>
        <table class="form-table">
            <tbody>
            <tr>
                <td style="padding: 0">
                    <?php if (!empty($mailerpress_sync) && !empty($mailerpress_sync['data']['contact_id'])) : ?>
                        <?php
                        $contact_id = $mailerpress_sync['data']['contact_id'];
                        $link = admin_url(
                                'admin.php?page=mailerpress%2Fcampaigns.php&path=%2Fhome%2Fcontacts&search=' . urlencode($user->user_email)
                        ); ?>
                        <a href="<?php echo esc_url($link); ?>" target="_blank"
                           style="color: green; font-weight: bold;">
                            <?php echo sprintf(esc_html("Synced (ID: %s)"), $contact_id); ?>
                        </a>
                    <?php else : ?>
                        <span style="color: red; font-weight: bold;">
                        <?php esc_html_e('Not synced', 'mailerpress-pro'); ?>
                    </span>
                    <?php endif; ?>
                </td>
            </tr>
            </tbody>
        </table>
        <?php
    }

}
