<?php

declare(strict_types=1);

namespace MailerPressPro\Services;

\defined('ABSPATH') || exit;

use DI\DependencyException;
use DI\NotFoundException;

class Activation
{
    /**
     * @throws DependencyException
     * @throws NotFoundException
     */
    public function activate(): void
    {
        update_option('mailerpress_pro_activated', 'yes');
        $this->ensureFreePlugin();
    }

    /**
     * Ensure the required free plugin is installed and activated
     */
    private function ensureFreePlugin(): void
    {
        include_once ABSPATH . 'wp-admin/includes/plugin.php';
        include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
        include_once ABSPATH . 'wp-admin/includes/file.php';
        include_once ABSPATH . 'wp-admin/includes/misc.php';

        $free_plugin_slug = 'mailerpress/mailerpress.php'; // folder/plugin-file.php
        $free_plugin_repo_slug = 'mailerpress'; // WP.org repo slug

        // If plugin folder doesn't exist, install it
        if (!file_exists(WP_PLUGIN_DIR . '/mailerpress/mailerpress.php')) {
            $upgrader = new \Plugin_Upgrader();
            $installed = $upgrader->install("https://downloads.wordpress.org/plugin/{$free_plugin_repo_slug}.latest-stable.zip");

            if ($installed) {
                activate_plugin($free_plugin_slug);
            } else {
                // Optional: admin notice if install failed
                add_action('admin_notices', function () {
                    echo '<div class="notice notice-error"><p>' . esc_html__('MailerPress Free plugin could not be installed automatically. Please install it manually.', 'mailerpress-pro') . '</p></div>';
                });
            }
        } elseif (!is_plugin_active($free_plugin_slug)) {
            activate_plugin($free_plugin_slug);
        }
    }
}
