<?php

namespace MailerPressPro\Core\Segmentation;

class SegmentQueryBuilder
{
    private Segment $segment;

    public function __construct(Segment $segment)
    {
        $this->segment = $segment;
    }

    public function buildQuery(array $options = []): string
    {
        global $wpdb;

        $whereParts = array_map(
            fn(SegmentCondition $condition) => $condition->toSqlCondition(),
            $this->segment->getConditions()
        );

        $logicalOperator = $this->segment->getOperator() === 'OR' ? 'OR' : 'AND';
        $whereClause = implode(" {$logicalOperator} ", $whereParts);

        $contactsTable = $wpdb->prefix . 'mailerpress_contact';

        // Determine SELECT fields
        $fields = $options['fields'] ?? '*';
        if (is_array($fields)) {
            $fields = implode(', ', array_map('esc_sql', $fields));
        }

        // Return full query
        return "SELECT {$fields} FROM {$contactsTable} AS c WHERE {$whereClause}";
    }

}