<?php

namespace MailerPressPro\Core\Segmentation;

class Segment
{
    private string $operator; // AND | OR
    /** @var SegmentCondition[] */
    private array $conditions = [];

    public function __construct(string $operator = 'AND', array $conditions = [])
    {
        $this->operator = strtoupper($operator);
        $this->conditions = $conditions;
    }

    public function addCondition(SegmentCondition $condition): void
    {
        $this->conditions[] = $condition;
    }

    public function getConditions(): array
    {
        return $this->conditions;
    }

    public function getOperator(): string
    {
        return $this->operator;
    }
}