<?php

namespace MailerPressPro\Api;

use MailerPressPro\Core\Attributes\Endpoint;

class Woocommerce
{
    #[Endpoint(
        'woocommerce/checkout-fields',
        methods: 'GET',
        permissionCallback: [Permissions::class, 'canEdit'],
    )]
    public function getCheckoutFields(): \WP_REST_Response
    {
        if (!function_exists('WC')) {
            return new \WP_REST_Response([], 200);
        }

        $checkout = WC()->checkout();
        $fields = $checkout->get_checkout_fields();

        $results = [];

        foreach ($fields as $groupKey => $groupFields) {
            foreach ($groupFields as $fieldKey => $fieldData) {
                $label = $fieldData['label'] ?? $fieldKey;
                $results[] = [
                    'group' => $groupKey, // e.g. billing, shipping, order
                    'label' => $label,
                    'value' => $fieldKey,
                ];
            }
        }

        return new \WP_REST_Response($results, 200);
    }
}