<?php

namespace MailerPressPro\Api;

use MailerPressPro\Core\Attributes\Endpoint;

class Pmpro
{
    #[Endpoint(
        'pmpro/membership-fields',
        methods: 'GET',
        permissionCallback: [Permissions::class, 'canEdit'],
    )]
    public function getMembershipFields(): \WP_REST_Response
    {
        if (!function_exists('pmpro_hasMembershipLevel')) {
            return new \WP_REST_Response([], 200);
        }

        // Paid Memberships Pro standard fields that can be mapped
        $results = [
            [
                'label' => __('Membership Level', 'mailerpress-pro'),
                'value' => 'membership_id',
            ],
            [
                'label' => __('Membership Status', 'mailerpress-pro'),
                'value' => 'membership_status',
            ],
            [
                'label' => __('Membership Start Date', 'mailerpress-pro'),
                'value' => 'membership_startdate',
            ],
            [
                'label' => __('Membership End Date', 'mailerpress-pro'),
                'value' => 'membership_enddate',
            ],
            [
                'label' => __('User First Name', 'mailerpress-pro'),
                'value' => 'user_first_name',
            ],
            [
                'label' => __('User Last Name', 'mailerpress-pro'),
                'value' => 'user_last_name',
            ],
            [
                'label' => __('User Email', 'mailerpress-pro'),
                'value' => 'user_email',
            ],
        ];

        return new \WP_REST_Response($results, 200);
    }
}

